function ConfTable = ConfTable_CV_2(ycal,LV_calibration,ts)

% INPUT : 
%         ycal       Referência das classes das amostras de calibração
%         yprev_cal  Valores previstos pelo modelo das amostras de calibração
%         ts         Limiares entre as classes
% OUTPUT:
%         Tabela de confusão 1 e 2

% yprev_cal_new=[];
% nc=[];

for fd = 1:size(ts,3) % Folds
    for lv = 1:1:size(ts,1) % LV 
        nc{:,:,fd,lv}=LV_calibration{:,:,fd,lv}-repmat(ts(lv,:,fd),[size(LV_calibration{:,:,fd,lv},1),1]);
        [~,idx]=max(nc{:,:,fd,lv},[],2);
        yprev_cal_new{:,fd,lv}=idx;
        YCAL = vet_matrix(ycal{:,:,fd,lv});
        class_param_cal(fd,lv) = calc_class_param(yprev_cal_new{:,fd,lv},YCAL);
    end
end

assignin('base','nc',nc);
assignin('base','yprev_cal_new',yprev_cal_new);
assignin('base','YCAL',YCAL);
assignin('base','class_param_cal',class_param_cal);

% ----- Table of classes -----
% Extracting class classification for each column 

for c = 1:size(class_param_cal(1).conf_mat,1)
    columns(1,c) = sprintf("Class_%02d",c);      
    rows(c,1) = sprintf("Predicted as Class %02d",c);
end
columns(:,end+1) = 'Unassigned';
assignin('base','rows',rows)
assignin('base','columns',columns)

for LV = 1:size(class_param_cal,2)
    data = class_param_cal(LV).conf_mat; 
    Table_classification{LV,1} = table(data,'RowNames', rows);
end
% 
% for c = 1:size(class_param_cal(LV).conf_mat,1)       
%     rows = sprintf("Predicted as Class %02d",c);
% end
assignin('base','Table_classification',Table_classification)

ConfTable.rows = rows;
ConfTable.columns = columns;
ConfTable.class_param_cal = class_param_cal;
ConfTable.Table_classification = Table_classification;

end
